<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\ProviderController;
use App\Http\Controllers\AppointmentController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::get('/test', function () {
    return response()->json(['message' => 'Hello, World!'], 200);
});
Route::get('/services', [ServiceController::class, 'index']);
Route::get('/services/{id}', [ServiceController::class, 'getServiceData']);
Route::get('/providers', [ProviderController::class, 'index']);


Route::post('/providers', [ProviderController::class, 'storeNewprovider']);
Route::post('/appointment', [AppointmentController::class, 'storeNewAppointment']);
