@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                <h4>Appointments</h4>
                </div>
            </div>

           
            
            <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                <th scope="col">#</th>
                <th scope="col">Name</th>
                <th scope="col">Mobile</th>
                <th scope="col">Service</th>
                <th scope="col">Provider</th>
                <th scope="col">Date</th>
                <th scope="col">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($appointments as $index => $app)
                    <tr>
                        <td>{{ $app->id }}</td>
                        <td>{{ $app->name }}</td>
                        <td>{{ $app->mobile }}</td>
                        <td>{{ $app->myService->name_ar ?? 'No service' }}</td>
                        <td>{{ $app->myProvider->name ?? 'No provider' }}</td>
                        <td>
                            <form action="/appointments" method="POST">
                                @csrf
                                <div class="d-flex align-items-center gap-2">
                                    <input type="text" id="datetime" name="date" value="{{ $app->date }}" class="form-control" placeholder="Select date and time">
                                    <input type="hidden" name="app_id" value="{{ $app->id }}">
                                    <input type="hidden" name="type" value="time">
                                    <button type="submit" class="btn btn-primary">
                                        Update
                                    </button>
                                </div>
                            </form>
                        </td>
                        <td>
                            <form action="/appointments" method="POST">
                                @csrf
                                <div class="d-flex align-items-center gap-2">
                                    <select name="status" class="form-select">
                                        <option value="pending" {{ $app->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="approved" {{ $app->status == 'approved' ? 'selected' : '' }}>Approved</option>
                                        <option value="rejected" {{ $app->status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                    </select>
                                    <input type="hidden" name="type" value="status">
                                    <input type="hidden" name="app_id" value="{{ $app->id }}">
                                    <button type="submit" class="btn btn-primary">
                                        Update
                                    </button>
                                </div>
                            </form>
                        </td>
                        <!-- <td>
                            <button class="btn btn-sm btn-primary">Edit</button>
                            <button class="btn btn-sm btn-danger">Delete</button>
                        </td> -->
                    </tr>
                @endforeach
                <!-- More rows here -->
            </tbody>
            </table>




            
            <script>
    flatpickr("#datetime", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
    });
</script>

        </div>
    </div>
</div>
@endsection
