<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Provider extends Model
{
    /** @use HasFactory<\Database\Factories\ProviderFactory> */
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'mobile',
        'name',
        'service',
        'status', // status can be 'pending', 'approved', 'rejected'
    ];

    public function myService()
    {
        return $this->belongsTo(Service::class, 'service');
    }
}
