<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Appointment;
use App\Models\Provider;
use App\Models\Service;
use App\Http\Requests\StoreProviderRequest;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }


    public function services()
    {
        $services = Service::all();
        return view('services', compact('services'));
    }
    public function providers()
    {
        $providers = Provider::with('myService')->get();
        return view('providers', compact('providers'));
    }
    public function appointments()
    {
        $appointments = Appointment::with('myService', 'myProvider')->get();
        return view('appointments', compact('appointments'));
    }


    public function providersUpdateStatus(StoreProviderRequest $request)
    {
        $provider = Provider::find($request->provider_id);
        $provider->status = $request->status;
        $provider->save();
  
        $providers = Provider::with('myService')->get();
        return view('providers', compact('providers'));
    }


    public function appointmentUpdate(StoreProviderRequest $request)
    {
        $app = Appointment::find($request->app_id);
        if($request->type == 'time') {
            $app->date = $request->date;
            $app->save();
            $appointments = Appointment::with('myService', 'myProvider')->get();
            return view('appointments', compact('appointments'));
        } else {
            $app->status = $request->status;
            $app->save();
            $appointments = Appointment::with('myService', 'myProvider')->get();
            return view('appointments', compact('appointments'));
      
        }
        
       
    }
}
